/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.cfg;

import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.exceptions.unchecked.JsonReferenceError;
import com.github.fge.jsonschema.exceptions.unchecked.ValidationConfigurationError;
import com.github.fge.jsonschema.library.DraftV3Library;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.messages.MessageBundle;
import com.github.fge.jsonschema.messages.MessageBundles;
import com.github.fge.jsonschema.messages.ValidationBundles;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.util.Thawed;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public final class ValidationConfigurationBuilder
implements Thawed<ValidationConfiguration> {
    private static final MessageBundle BUNDLE = ValidationBundles.VALIDATION_CFG;
    private static final MessageBundle REF_BUNDLE = MessageBundles.JSON_REF;
    private static final Map<SchemaVersion, Library> DEFAULT_LIBRARIES = Maps.newEnumMap(SchemaVersion.class);
    final Map<JsonRef, Library> libraries;
    Library defaultLibrary = DEFAULT_LIBRARIES.get(SchemaVersion.DRAFTV4);
    boolean useFormat = true;

    ValidationConfigurationBuilder() {
        this.libraries = Maps.newHashMap();
        for (Map.Entry<SchemaVersion, Library> entry : DEFAULT_LIBRARIES.entrySet()) {
            JsonRef ref = JsonRef.fromURI((URI)entry.getKey().getLocation());
            Library library = entry.getValue();
            this.libraries.put(ref, library);
        }
    }

    ValidationConfigurationBuilder(ValidationConfiguration cfg) {
        this.libraries = Maps.newHashMap(cfg.libraries);
        this.defaultLibrary = cfg.defaultLibrary;
        this.useFormat = cfg.useFormat;
    }

    public ValidationConfigurationBuilder addLibrary(String uri, Library library) {
        JsonRef ref;
        try {
            ref = JsonRef.fromString((String)uri);
            if (!ref.isAbsolute()) {
                throw new JsonReferenceError(REF_BUNDLE.getString("uriNotAbsolute"));
            }
        }
        catch (JsonReferenceException e) {
            throw new JsonReferenceError(e.getProcessingMessage());
        }
        BUNDLE.checkNotNull(library, "nullLibrary");
        if (this.libraries.containsKey(ref)) {
            throw new ValidationConfigurationError(BUNDLE.message("dupLibrary").put("uri", (Object)ref));
        }
        this.libraries.put(ref, library);
        return this;
    }

    public ValidationConfigurationBuilder setDefaultVersion(SchemaVersion version) {
        BUNDLE.checkNotNull(version, "nullVersion");
        this.defaultLibrary = DEFAULT_LIBRARIES.get(version);
        return this;
    }

    public ValidationConfigurationBuilder setDefaultLibrary(String uri, Library library) {
        this.addLibrary(uri, library);
        this.defaultLibrary = library;
        return this;
    }

    public ValidationConfigurationBuilder setUseFormat(boolean useFormat) {
        this.useFormat = useFormat;
        return this;
    }

    public ValidationConfiguration freeze() {
        return new ValidationConfiguration(this);
    }

    static {
        DEFAULT_LIBRARIES.put(SchemaVersion.DRAFTV3, DraftV3Library.get());
        DEFAULT_LIBRARIES.put(SchemaVersion.DRAFTV4, DraftV4Library.get());
    }
}

