/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.messages.FormatMessages;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.collect.ImmutableList;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateTimeAttribute
extends AbstractFormatAttribute {
    private static final String FORMAT1 = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final DateTimeFormatter FMT1 = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ");
    private static final String FORMAT2 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final DateTimeFormatter FMT2 = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final FormatAttribute INSTANCE = new DateTimeAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private DateTimeAttribute() {
        super("date-time", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, FullData data) throws ProcessingException {
        String value = data.getInstance().getNode().textValue();
        try {
            FMT1.parseDateTime(value);
            return;
        }
        catch (IllegalArgumentException ignored) {
            try {
                FMT2.parseDateTime(value);
                return;
            }
            catch (IllegalArgumentException ignored2) {
                report.error(this.newMsg(data, FormatMessages.INVALID_DATE_FORMAT).put("expected", (Iterable)ImmutableList.of((Object)FORMAT1, (Object)FORMAT2)));
                return;
            }
        }
    }
}

