/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.processing.ProcessingResult;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorMap;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.DevNullProcessingReport;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.tree.CanonicalSchemaTree;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.AsJson;
import com.github.fge.jsonschema.util.ValueHolder;
import com.google.common.base.Function;
import java.util.Map;

public final class SyntaxValidator {
    private static final Function<ValueHolder<SchemaTree>, JsonRef> FUNCTION = new Function<ValueHolder<SchemaTree>, JsonRef>(){

        public JsonRef apply(ValueHolder<SchemaTree> input) {
            return ((SchemaTree)input.getValue()).getDollarSchema();
        }
    };
    private final Processor<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> processor;

    public SyntaxValidator(ValidationConfiguration cfg) {
        ProcessorMap map = new ProcessorMap(FUNCTION);
        SyntaxProcessor byDefault = new SyntaxProcessor(cfg.getDefaultLibrary().getSyntaxCheckers());
        map.setDefaultProcessor((Processor)byDefault);
        Map<JsonRef, Library> libraries = cfg.getLibraries();
        for (Map.Entry<JsonRef, Library> entry : libraries.entrySet()) {
            JsonRef ref = entry.getKey();
            Dictionary<SyntaxChecker> dict = entry.getValue().getSyntaxCheckers();
            SyntaxProcessor syntaxProcessor = new SyntaxProcessor(dict);
            map.addEntry((Object)ref, (Processor)syntaxProcessor);
        }
        this.processor = map.getProcessor();
    }

    public boolean schemaIsValid(JsonNode schema) {
        DevNullProcessingReport report = new DevNullProcessingReport();
        return this.getResult(schema, (ProcessingReport)report).isSuccess();
    }

    public ProcessingReport validateSchema(JsonNode schema) {
        ListProcessingReport report = new ListProcessingReport();
        return this.getResult(schema, (ProcessingReport)report).getReport();
    }

    public Processor<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> getProcessor() {
        return this.processor;
    }

    private ProcessingResult<ValueHolder<SchemaTree>> getResult(JsonNode schema, ProcessingReport report) {
        ValueHolder<SchemaTree> holder = SyntaxValidator.holder(schema);
        return ProcessingResult.uncheckedResult(this.processor, (ProcessingReport)report, holder);
    }

    private static ValueHolder<SchemaTree> holder(JsonNode node) {
        return ValueHolder.hold((String)"schema", (AsJson)new CanonicalSchemaTree(node));
    }
}

