/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main;

import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.exceptions.unchecked.FactoryConfigurationError;
import com.github.fge.jsonschema.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.messages.ConfigurationMessages;
import com.github.fge.jsonschema.report.ListReportProvider;
import com.github.fge.jsonschema.report.LogLevel;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ReportProvider;
import com.github.fge.jsonschema.util.Thawed;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class JsonSchemaFactoryBuilder
implements Thawed<JsonSchemaFactory> {
    ReportProvider reportProvider;
    LoadingConfiguration loadingCfg;
    ValidationConfiguration validationCfg;

    JsonSchemaFactoryBuilder() {
        this.reportProvider = new ListReportProvider(LogLevel.INFO, LogLevel.FATAL);
        this.loadingCfg = LoadingConfiguration.byDefault();
        this.validationCfg = ValidationConfiguration.byDefault();
    }

    JsonSchemaFactoryBuilder(JsonSchemaFactory factory) {
        this.reportProvider = factory.reportProvider;
        this.loadingCfg = factory.loadingCfg;
        this.validationCfg = factory.validationCfg;
    }

    public JsonSchemaFactoryBuilder setReportProvider(ReportProvider reportProvider) {
        if (reportProvider == null) {
            throw new FactoryConfigurationError(new ProcessingMessage().message((Object)ConfigurationMessages.NULL_REPORT_PROVIDER));
        }
        this.reportProvider = reportProvider;
        return this;
    }

    public JsonSchemaFactoryBuilder setLoadingConfiguration(LoadingConfiguration loadingCfg) {
        if (loadingCfg == null) {
            throw new FactoryConfigurationError(new ProcessingMessage().message((Object)ConfigurationMessages.NULL_LOADING_CFG));
        }
        this.loadingCfg = loadingCfg;
        return this;
    }

    public JsonSchemaFactoryBuilder setValidationConfiguration(ValidationConfiguration validationCfg) {
        if (validationCfg == null) {
            throw new FactoryConfigurationError(new ProcessingMessage().message((Object)ConfigurationMessages.NULL_VALIDATION_CFG));
        }
        this.validationCfg = validationCfg;
        return this;
    }

    public JsonSchemaFactory freeze() {
        return new JsonSchemaFactory(this);
    }
}

