/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.processing.ProcessingResult;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.report.ReportProvider;
import com.github.fge.jsonschema.tree.JsonTree;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.tree.SimpleJsonTree;
import net.jcip.annotations.Immutable;

@Immutable
public final class JsonSchema {
    private final ValidationProcessor processor;
    private final SchemaTree schema;
    private final ReportProvider reportProvider;

    JsonSchema(ValidationProcessor processor, SchemaTree schema, ReportProvider reportProvider) {
        this.processor = processor;
        this.schema = schema;
        this.reportProvider = reportProvider;
    }

    private ProcessingReport doValidate(JsonNode node) throws ProcessingException {
        FullData data = new FullData(this.schema, (JsonTree)new SimpleJsonTree(node));
        ProcessingReport report = this.reportProvider.newReport();
        ProcessingResult result = ProcessingResult.of((Processor)this.processor, (ProcessingReport)report, (MessageProvider)data);
        return result.getReport();
    }

    private ProcessingReport doValidateUnchecked(JsonNode node) {
        FullData data = new FullData(this.schema, (JsonTree)new SimpleJsonTree(node));
        ProcessingReport report = this.reportProvider.newReport();
        ProcessingResult result = ProcessingResult.uncheckedResult((Processor)this.processor, (ProcessingReport)report, (MessageProvider)data);
        return result.getReport();
    }

    public ProcessingReport validate(JsonNode instance) throws ProcessingException {
        return this.doValidate(instance);
    }

    public ProcessingReport validateUnchecked(JsonNode instance) {
        return this.doValidateUnchecked(instance);
    }

    public boolean validInstance(JsonNode instance) throws ProcessingException {
        return this.doValidate(instance).isSuccess();
    }

    public boolean validInstanceUnchecked(JsonNode instance) {
        return this.doValidateUnchecked(instance).isSuccess();
    }
}

