/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.schema.SchemaContext;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public final class InlineSchemaContext
extends SchemaContext {
    private final Map<JsonRef, JsonNode> schemas;

    InlineSchemaContext(JsonNode schema) {
        super(InlineSchemaContext.extractLocator(schema).toURI(), schema);
        HashMap map = Maps.newHashMap();
        map.put(this.locator, this.schema);
        InlineSchemaContext.fillURIMap(this.locator, this.schema, map);
        this.schemas = ImmutableMap.copyOf((Map)map);
    }

    @Override
    public boolean contains(JsonRef other) {
        return this.schemas.containsKey(other) || this.locator.contains(other);
    }

    @Override
    public JsonNode resolve(JsonRef ref) {
        return this.schemas.containsKey(ref) ? this.schemas.get(ref) : ref.getFragment().resolve(this.schema);
    }

    private static JsonRef extractLocator(JsonNode node) {
        try {
            return InlineSchemaContext.refFromNode(node.path("id"));
        }
        catch (JsonSchemaException ignored) {
            return JsonRef.emptyRef();
        }
    }

    private static void fillURIMap(JsonRef baseRef, JsonNode node, Map<JsonRef, JsonNode> map) {
        if (!node.isObject()) {
            return;
        }
        for (JsonNode child : node) {
            if (child.has("id")) {
                try {
                    JsonRef idRef = InlineSchemaContext.refFromNode(child.get("id"));
                    JsonRef resolvedRef = baseRef.resolve(idRef);
                    map.put(resolvedRef, InlineSchemaContext.cleanup(child));
                }
                catch (JsonSchemaException ignored) {
                    // empty catch block
                }
            }
            InlineSchemaContext.fillURIMap(baseRef, InlineSchemaContext.cleanup(child), map);
        }
    }

    private static JsonRef refFromNode(JsonNode node) throws JsonSchemaException {
        return node.isTextual() ? JsonRef.fromString(node.textValue()) : JsonRef.emptyRef();
    }
}

