/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.processing.LogLevel;
import com.github.fge.jsonschema.util.AsJson;
import com.github.fge.jsonschema.util.jackson.JacksonUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public final class ProcessingMessage
implements AsJson {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final Map<String, JsonNode> map = Maps.newLinkedHashMap();
    private LogLevel level;

    public ProcessingMessage() {
        this.setLogLevel(LogLevel.INFO);
    }

    public ProcessingMessage setLogLevel(LogLevel level) {
        this.level = (LogLevel)((Object)Preconditions.checkNotNull((Object)((Object)level), (Object)"log level cannot be null"));
        return this.put("level", level);
    }

    public ProcessingMessage msg(String message) {
        return this.put("message", message);
    }

    public <T> ProcessingMessage msg(T value) {
        return this.put("message", value);
    }

    public ProcessingMessage put(String key, JsonNode value) {
        if (value == null) {
            return this.putNull(key);
        }
        this.map.put(key, value.deepCopy());
        return this;
    }

    public ProcessingMessage put(String key, AsJson asJson) {
        return this.put(key, asJson.asJson());
    }

    public ProcessingMessage put(String key, String value) {
        return value == null ? this.putNull(key) : this.put(key, (JsonNode)FACTORY.textNode(value));
    }

    public ProcessingMessage put(String key, int value) {
        return this.put(key, (JsonNode)FACTORY.numberNode(value));
    }

    public <T> ProcessingMessage put(String key, T value) {
        return value == null ? this.putNull(key) : this.put(key, (JsonNode)FACTORY.textNode(value.toString()));
    }

    public <T> ProcessingMessage put(String key, Iterable<T> values) {
        if (values == null) {
            return this.putNull(key);
        }
        ArrayNode node = FACTORY.arrayNode();
        for (T value : values) {
            node.add((JsonNode)(value == null ? FACTORY.nullNode() : FACTORY.textNode(value.toString())));
        }
        return this.put(key, (JsonNode)node);
    }

    public LogLevel getLogLevel() {
        return this.level;
    }

    private ProcessingMessage putNull(String key) {
        this.map.put(key, (JsonNode)FACTORY.nullNode());
        return this;
    }

    @Override
    public JsonNode asJson() {
        ObjectNode ret = FACTORY.objectNode();
        ret.putAll(this.map);
        return ret;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessingMessage other = (ProcessingMessage)obj;
        return this.map.equals(other.map);
    }

    public String toString() {
        return this.map.toString();
    }
}

