/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.syntax.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.RhinoHelper;
import java.util.List;

public final class PatternSyntaxChecker
extends AbstractSyntaxChecker {
    private static final PatternSyntaxChecker INSTANCE = new PatternSyntaxChecker();

    public static PatternSyntaxChecker getInstance() {
        return INSTANCE;
    }

    private PatternSyntaxChecker() {
        super("pattern", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        String value = schema.get(this.keyword).textValue();
        if (RhinoHelper.regexIsValid(value)) {
            return;
        }
        messages.add(this.newMsg().addInfo("found", value).setMessage("pattern is not a valid ECMA 262 regex").build());
    }
}

