/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.keyword.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.keyword.draftv3.AbstractTypeKeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.ValidationContext;

public final class DisallowKeywordValidator
extends AbstractTypeKeywordValidator {
    public DisallowKeywordValidator(JsonNode schema) {
        super("disallow", schema);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        NodeType type = NodeType.getNodeType(instance);
        if (this.typeSet.contains((Object)type)) {
            Message.Builder msg = this.newMsg().addInfo("found", type).addInfo("disallowed", this.typeSet).setMessage("instance type is not allowed");
            report.addMessage(msg.build());
            return;
        }
        if (this.schemas.isEmpty()) {
            return;
        }
        for (JsonNode schema : this.schemas) {
            JsonValidator validator = context.newValidator(schema);
            ValidationReport schemaReport = report.copy();
            validator.validate(context, schemaReport, instance);
            if (schemaReport.hasFatalError()) {
                report.mergeWith(schemaReport);
                return;
            }
            if (!schemaReport.isSuccess()) continue;
            Message.Builder msg = this.newMsg().setMessage("instance is valid against a disallowed schema");
            report.addMessage(msg.build());
            return;
        }
    }
}

