/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.keyword.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.keyword.KeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.ValidationContext;

public final class AdditionalItemsKeywordValidator
extends KeywordValidator {
    private boolean additionalOK;
    private int itemsCount = 0;

    public AdditionalItemsKeywordValidator(JsonNode schema) {
        super("additionalItems", NodeType.ARRAY);
        this.additionalOK = schema.get(this.keyword).asBoolean(true);
        if (this.additionalOK) {
            return;
        }
        JsonNode items = schema.path("items");
        if (items.isArray()) {
            this.itemsCount = items.size();
        } else {
            this.additionalOK = true;
        }
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (instance.size() > this.itemsCount) {
            Message.Builder msg = this.newMsg().setMessage("additional items are not permitted").addInfo("max", this.itemsCount).addInfo("found", instance.size());
            report.addMessage(msg.build());
        }
    }

    @Override
    public boolean alwaysTrue() {
        return this.additionalOK;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.keyword).append(": ");
        if (this.additionalOK) {
            sb.append("no constraints");
        } else {
            sb.append(this.itemsCount).append(" max");
        }
        return sb.toString();
    }
}

