/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.keyword.NumericKeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import java.math.BigDecimal;

public abstract class DivisorKeywordValidator
extends NumericKeywordValidator {
    protected DivisorKeywordValidator(String keyword, JsonNode schema) {
        super(keyword, schema);
    }

    @Override
    protected final void validateLong(ValidationReport report, JsonNode instance) {
        long longValue;
        long instanceValue = instance.longValue();
        long remainder = instanceValue % (longValue = this.number.longValue());
        if (remainder == 0L) {
            return;
        }
        Message.Builder msg = this.newMsg().setMessage("number is not a multiple of " + this.keyword).addInfo("value", instance).addInfo("divisor", this.number);
        report.addMessage(msg.build());
    }

    @Override
    protected final void validateDecimal(ValidationReport report, JsonNode instance) {
        BigDecimal decimalValue;
        BigDecimal instanceValue = instance.decimalValue();
        BigDecimal remainder = instanceValue.remainder(decimalValue = this.number.decimalValue());
        if (remainder.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        Message.Builder msg = this.newMsg().setMessage("number is not a multiple of " + this.keyword).addInfo("value", instance).addInfo("divisor", this.number);
        report.addMessage(msg.build());
    }
}

