/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.KeywordBuilder;
import com.github.fge.jsonschema.util.Frozen;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import java.util.EnumSet;

public final class Keyword
implements Frozen<KeywordBuilder> {
    final String name;
    final SyntaxChecker syntaxChecker;
    final Class<? extends KeywordValidator> validatorClass;
    final EnumSet<NodeType> types;
    final Equivalence<JsonNode> equivalence;

    public static KeywordBuilder newBuilder(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        return new KeywordBuilder(name);
    }

    Keyword(KeywordBuilder builder) {
        this.name = (String)Preconditions.checkNotNull((Object)builder.name, (Object)"keyword must not be null");
        this.syntaxChecker = builder.syntaxChecker;
        this.validatorClass = builder.validatorClass;
        this.types = EnumSet.copyOf(builder.types);
        this.equivalence = builder.equivalence;
    }

    @Override
    public KeywordBuilder thaw() {
        return new KeywordBuilder(this);
    }
}

