/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.keyword.validator.SchemaArrayKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.JsonSchemaTree;

public final class AllOfKeywordValidator
extends SchemaArrayKeywordValidator {
    public AllOfKeywordValidator(JsonNode digest) {
        super("allOf");
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        JsonSchemaTree schemaTree = data.getSchema();
        JsonNode schemas = schemaTree.getCurrentNode().get(this.keyword);
        int size = schemas.size();
        ObjectNode fullReport = FACTORY.objectNode();
        int nrSuccess = 0;
        for (int index = 0; index < size; ++index) {
            ListProcessingReport subReport = new ListProcessingReport();
            JsonPointer ptr = this.basePointer.append(index);
            schemaTree.append(ptr);
            processor.process(subReport, data);
            schemaTree.pop();
            fullReport.put(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess != size) {
            report.error(this.newMsg(data).msg(KeywordValidationMessages.ALLOF_FAIL).put("nrSchemas", size).put("matched", nrSuccess).put("reports", (JsonNode)fullReport));
        }
    }
}

