/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.RhinoHelper;

public final class PatternKeywordValidator
extends AbstractKeywordValidator {
    public PatternKeywordValidator(JsonNode digest) {
        super("pattern");
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        String value;
        String regex = data.getSchema().getCurrentNode().get(this.keyword).textValue();
        if (!RhinoHelper.regMatch(regex, value = data.getInstance().getCurrentNode().textValue())) {
            report.error(this.newMsg(data).msg(KeywordValidationMessages.REGEX_NO_MATCH).put("regex", regex).put("string", value));
        }
    }

    @Override
    public String toString() {
        return this.keyword;
    }
}

