/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.validator.PositiveIntegerKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;

public final class MinLengthKeywordValidator
extends PositiveIntegerKeywordValidator {
    public MinLengthKeywordValidator(JsonNode digested) {
        super("minLength", digested);
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        int size = data.getInstance().getCurrentNode().textValue().length();
        if (size < this.intValue) {
            report.error(this.newMsg(data).msg(KeywordValidationMessages.STRING_TOO_SHORT).put(this.keyword, this.intValue).put("found", size));
        }
    }
}

