/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.jackson.JacksonUtils;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.ValidationContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

final class ArrayValidator
implements JsonValidator {
    private final JsonNode additionalItems;
    private final List<JsonNode> items;

    ArrayValidator(JsonNode schema) {
        JsonNode node = schema.path("items");
        if (!node.isArray()) {
            this.additionalItems = node.isObject() ? node : JacksonUtils.emptyObject();
            this.items = Collections.emptyList();
            return;
        }
        this.items = ImmutableList.copyOf((Iterable)node);
        node = schema.path("additionalItems");
        this.additionalItems = node.isObject() ? node : JacksonUtils.emptyObject();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        for (int i = 0; i < instance.size(); ++i) {
            report.pushd(i);
            JsonNode element = instance.get(i);
            JsonNode subSchema = this.getSchema(i);
            JsonValidator validator = context.newValidator(subSchema);
            validator.validate(context, report, element);
            report.popd();
            if (report.hasFatalError()) break;
        }
    }

    @VisibleForTesting
    JsonNode getSchema(int index) {
        return index >= this.items.size() ? this.additionalItems : this.items.get(index);
    }
}

