/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.processing.syntax.SyntaxReport;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.github.fge.jsonschema.tree.JsonSchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.ProcessingCache;
import com.github.fge.jsonschema.util.equivalence.SyntaxCheckingEquivalence;
import com.google.common.base.Equivalence;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class SyntaxProcessor
implements Processor<ValidationData, ValidationData> {
    private final Dictionary<SyntaxChecker> dict;
    private final ProcessingCache<JsonSchemaTree, SyntaxReport> cache;

    public SyntaxProcessor(Dictionary<SyntaxChecker> dict) {
        this.dict = dict;
        this.cache = new ProcessingCache<JsonSchemaTree, SyntaxReport>(SyntaxCheckingEquivalence.getInstance(), this.loader());
    }

    @Override
    public ValidationData process(ProcessingReport report, ValidationData input) throws ProcessingException {
        JsonSchemaTree inputSchema = input.getSchema();
        JsonSchemaTree tree = inputSchema.copy();
        JsonPointer pointer = inputSchema.getCurrentPointer();
        tree.setPointer(JsonPointer.empty());
        SyntaxReport syntaxReport = this.cache.getUnchecked(tree);
        if (syntaxReport.hasIgnoredPath(pointer)) {
            tree.setPointer(pointer);
            syntaxReport = this.cache.getUnchecked(tree);
        }
        syntaxReport.injectMessages(report);
        return input;
    }

    private CacheLoader<Equivalence.Wrapper<JsonSchemaTree>, SyntaxReport> loader() {
        return new CacheLoader<Equivalence.Wrapper<JsonSchemaTree>, SyntaxReport>(){

            public SyntaxReport load(Equivalence.Wrapper<JsonSchemaTree> key) throws ProcessingException {
                SyntaxReport report = new SyntaxReport();
                SyntaxProcessor.this.validate(report, (JsonSchemaTree)key.get());
                return report;
            }
        };
    }

    private void validate(SyntaxReport report, JsonSchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getCurrentNode();
        NodeType type = NodeType.getNodeType(node);
        if (type != NodeType.OBJECT) {
            ProcessingMessage msg = SyntaxProcessor.newMsg(tree).msg(SyntaxMessages.NOT_A_SCHEMA).put("found", type);
            report.error(msg);
            return;
        }
        HashSet fieldNames = Sets.newHashSet((Iterator)node.fieldNames());
        Set<String> ignored = this.dict.missingEntriesFrom(fieldNames);
        if (!ignored.isEmpty()) {
            JsonPointer pointer = tree.getCurrentPointer();
            for (String name : ignored) {
                report.addIgnoredPath(pointer.append(name));
            }
            report.warn(SyntaxProcessor.newMsg(tree).msg(SyntaxMessages.UNKNOWN_KEYWORDS).put("ignored", ignored));
        }
        ArrayList pointers = Lists.newArrayList();
        for (SyntaxChecker checker : this.dict.valuesForKeys(fieldNames)) {
            checker.checkSyntax(pointers, report, tree);
        }
        for (JsonPointer pointer : pointers) {
            tree.append(pointer);
            this.validate(report, tree);
            tree.pop();
        }
    }

    private static ProcessingMessage newMsg(JsonSchemaTree tree) {
        return new ProcessingMessage().put("schema", tree).put("domain", "syntax");
    }
}

