/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing;

import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingReport;

public final class ProcessorChain<IN extends MessageProvider, OUT extends MessageProvider>
implements Processor<IN, OUT> {
    private final Processor<IN, OUT> p;

    public static <X extends MessageProvider, Y extends MessageProvider> ProcessorChain<X, Y> startWith(Processor<X, Y> p) {
        return new ProcessorChain<X, Y>(p);
    }

    public static <X extends MessageProvider> ProcessorChain<X, X> start() {
        Processor p = new Processor<X, X>(){

            @Override
            public X process(ProcessingReport report, X input) throws ProcessingException {
                return input;
            }
        };
        return new ProcessorChain(p);
    }

    private ProcessorChain(Processor<IN, OUT> p) {
        this.p = p;
    }

    public ProcessorChain<IN, OUT> failOnError() {
        Processor fail = new Processor<OUT, OUT>(){

            @Override
            public OUT process(ProcessingReport report, OUT input) throws ProcessingException {
                if (!report.isSuccess()) {
                    throw new ProcessingException("chain stopped");
                }
                return input;
            }
        };
        return new ProcessorChain(ProcessorChain.merge(this.p, fail));
    }

    public <NEWOUT extends MessageProvider> ProcessorChain<IN, NEWOUT> chainWith(Processor<OUT, NEWOUT> p2) {
        return new ProcessorChain<IN, NEWOUT>(ProcessorChain.merge(this.p, p2));
    }

    public Processor<IN, OUT> end() {
        return this;
    }

    @Override
    public OUT process(ProcessingReport report, IN input) throws ProcessingException {
        return this.p.process(report, input);
    }

    private static <X extends MessageProvider, Y extends MessageProvider, Z extends MessageProvider> Processor<X, Z> merge(final Processor<X, Y> p1, final Processor<Y, Z> p2) {
        return new Processor<X, Z>(){

            @Override
            public Z process(ProcessingReport report, X input) throws ProcessingException {
                return p2.process(report, p1.process(report, input));
            }
        };
    }
}

