/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.syntax.SyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxValidator;
import com.github.fge.jsonschema.report.Domain;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.util.NodeType;
import java.util.EnumSet;
import java.util.List;

public abstract class AbstractSyntaxChecker
implements SyntaxChecker {
    protected final String keyword;
    private final EnumSet<NodeType> validTypes;

    protected AbstractSyntaxChecker(String keyword, NodeType type, NodeType ... types) {
        this.keyword = keyword;
        this.validTypes = EnumSet.of(type, types);
    }

    @Override
    public final void checkSyntax(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        NodeType nodeType = NodeType.getNodeType(schema.get(this.keyword));
        if (!this.validTypes.contains((Object)nodeType)) {
            messages.add(this.newMsg().setMessage("incorrect type for value").addInfo("expected", this.validTypes).addInfo("found", nodeType).build());
            return;
        }
        this.checkValue(validator, messages, schema);
    }

    public abstract void checkValue(SyntaxValidator var1, List<Message> var2, JsonNode var3);

    protected final Message.Builder newMsg() {
        return Domain.SYNTAX.newMessage().setKeyword(this.keyword);
    }
}

