/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.metaschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.keyword.KeywordValidator;
import com.github.fge.jsonschema.main.Keyword;
import com.github.fge.jsonschema.metaschema.BuiltinSchemas;
import com.github.fge.jsonschema.metaschema.KeywordRegistry;
import com.github.fge.jsonschema.old.syntax.SyntaxChecker;
import com.github.fge.jsonschema.ref.JsonRef;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public final class MetaSchema {
    private final JsonRef dollarSchema;
    private final JsonNode rawSchema;
    private final Map<String, SyntaxChecker> syntaxCheckers;
    private final Map<String, Class<? extends KeywordValidator>> validators;
    private final Map<String, FormatAttribute> formatAttributes;

    private MetaSchema(Builder builder) {
        JsonRef ref = builder.dollarSchema;
        Preconditions.checkNotNull((Object)ref, (Object)"a schema URI must be provided");
        Preconditions.checkArgument((boolean)ref.isAbsolute(), (Object)"provided schema URI is not an absolute JSON Reference");
        this.dollarSchema = ref;
        this.rawSchema = builder.rawSchema;
        this.syntaxCheckers = ImmutableMap.copyOf((Map)builder.syntaxCheckers);
        this.validators = ImmutableMap.copyOf((Map)builder.validators);
        this.formatAttributes = ImmutableMap.copyOf((Map)builder.formatAttributes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder basedOn(BuiltinSchemas builtin) {
        return new Builder(builtin);
    }

    public static MetaSchema copyOf(BuiltinSchemas builtin) {
        return new Builder(builtin).build();
    }

    public JsonRef getDollarSchema() {
        return this.dollarSchema;
    }

    public Map<String, Class<? extends KeywordValidator>> getValidators() {
        return this.validators;
    }

    public Map<String, SyntaxChecker> getSyntaxCheckers() {
        return this.syntaxCheckers;
    }

    public Map<String, FormatAttribute> getFormatAttributes() {
        return this.formatAttributes;
    }

    public static final class Builder {
        private JsonRef dollarSchema;
        private JsonNode rawSchema;
        private final Map<String, SyntaxChecker> syntaxCheckers;
        private final Map<String, Class<? extends KeywordValidator>> validators;
        private final Map<String, FormatAttribute> formatAttributes;

        private Builder() {
            this.syntaxCheckers = Maps.newHashMap();
            this.validators = Maps.newHashMap();
            this.formatAttributes = Maps.newHashMap();
        }

        private Builder(BuiltinSchemas builtin) {
            this.dollarSchema = JsonRef.fromURI(builtin.getURI());
            this.rawSchema = builtin.getRawSchema();
            this.syntaxCheckers = Maps.newHashMap(builtin.checkers);
            this.validators = Maps.newHashMap(builtin.validators);
            this.formatAttributes = Maps.newHashMap(builtin.formatAttributes);
        }

        public Builder withURI(String uri) {
            Preconditions.checkNotNull((Object)uri, (Object)"URI cannot be null");
            this.dollarSchema = JsonRef.fromURI(URI.create(uri));
            return this;
        }

        public Builder withRawSchema(JsonNode rawSchema) {
            this.rawSchema = rawSchema;
            return this;
        }

        public Builder addKeyword(Keyword keyword) {
            Preconditions.checkNotNull((Object)keyword, (Object)"keyword must not be null");
            String name = keyword.getName();
            SyntaxChecker checker = keyword.getSyntaxChecker();
            Class<? extends KeywordValidator> validator = keyword.getValidatorClass();
            this.syntaxCheckers.remove(name);
            this.validators.remove(name);
            if (checker != null) {
                this.syntaxCheckers.put(name, checker);
            }
            if (validator != null) {
                this.validators.put(name, validator);
            }
            return this;
        }

        public Builder removeKeyword(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
            this.syntaxCheckers.remove(name);
            this.validators.remove(name);
            return this;
        }

        public Builder addFormatAttribute(String fmt, FormatAttribute formatAttribute) {
            Preconditions.checkNotNull((Object)fmt, (Object)"format attribute name must not be null");
            Preconditions.checkNotNull((Object)formatAttribute, (Object)"format attribute implementation must not be null");
            this.formatAttributes.put(fmt, formatAttribute);
            return this;
        }

        public Builder removeFormatAttribute(String fmt) {
            Preconditions.checkNotNull((Object)fmt, (Object)"format attribute name must not be null");
            this.formatAttributes.remove(fmt);
            return this;
        }

        @Deprecated
        public Builder addKeywordRegistry(KeywordRegistry registry) {
            this.syntaxCheckers.putAll(registry.getSyntaxCheckers());
            this.validators.putAll(registry.getValidators());
            this.formatAttributes.putAll(registry.getFormatAttributes());
            return this;
        }

        public MetaSchema build() {
            return new MetaSchema(this);
        }
    }
}

