/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.KeywordValidator;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.ValidationContext;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class ExtendsKeywordValidator
extends KeywordValidator {
    private final Set<JsonNode> schemas;

    public ExtendsKeywordValidator(JsonNode schema) {
        super("extends", NodeType.values());
        JsonNode node = schema.get(this.keyword);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (node.isObject()) {
            builder.add((Object)node);
        } else {
            builder.addAll((Iterable)node);
        }
        this.schemas = builder.build();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        for (JsonNode schema : this.schemas) {
            JsonValidator validator = context.newValidator(schema);
            validator.validate(context, report, instance);
            if (!report.hasFatalError()) continue;
            return;
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.schemas.size() + " schema(s)";
    }
}

