/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.KeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import com.github.fge.jsonschema.validator.ValidationContext;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class EnumKeywordValidator
extends KeywordValidator {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();
    private final JsonNode enumNode;
    private final Set<Equivalence.Wrapper<JsonNode>> enumValues;

    public EnumKeywordValidator(JsonNode schema) {
        super("enum", NodeType.values());
        this.enumNode = schema.get(this.keyword);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode value : this.enumNode) {
            builder.add((Object)EQUIVALENCE.wrap((Object)value));
        }
        this.enumValues = builder.build();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (this.enumValues.contains(EQUIVALENCE.wrap((Object)instance))) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo("value", instance).addInfo("enum", this.enumNode).setMessage("value not found in enum");
        report.addMessage(msg.build());
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.enumValues.size() + " possible value(s)";
    }
}

