/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.keyword.KeywordFactory;
import com.github.fge.jsonschema.keyword.KeywordValidator;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.metaschema.MetaSchema;
import com.github.fge.jsonschema.old.syntax.SyntaxValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.schema.SchemaNode;
import com.github.fge.jsonschema.schema.SchemaRegistry;
import com.github.fge.jsonschema.util.jackson.JacksonUtils;
import com.github.fge.jsonschema.validator.InstanceValidator;
import com.github.fge.jsonschema.validator.JsonResolver;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.ValidationContext;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JsonValidatorCache {
    private static final JsonValidator ALWAYS_TRUE = new JsonValidator(){

        @Override
        public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        }
    };
    private final LoadingCache<SchemaNode, JsonValidator> cache;
    private final JsonResolver resolver;
    private final SyntaxValidator syntaxValidator;
    private final KeywordFactory keywordFactory;
    private final Map<String, FormatAttribute> formatAttributes;

    public JsonValidatorCache(MetaSchema metaSchema, SchemaRegistry schemaRegistry) {
        this.resolver = new JsonResolver(schemaRegistry);
        this.syntaxValidator = new SyntaxValidator(metaSchema);
        this.keywordFactory = new KeywordFactory(metaSchema);
        this.formatAttributes = metaSchema.getFormatAttributes();
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build(this.cacheLoader());
    }

    public Map<String, FormatAttribute> getFormatAttributes() {
        return this.formatAttributes;
    }

    public JsonValidator getValidator(SchemaNode schemaNode) {
        return (JsonValidator)this.cache.getUnchecked((Object)schemaNode);
    }

    private CacheLoader<SchemaNode, JsonValidator> cacheLoader() {
        return new CacheLoader<SchemaNode, JsonValidator>(){

            public JsonValidator load(SchemaNode key) {
                SchemaNode realNode;
                if (key.getNode().equals((Object)JacksonUtils.emptyObject())) {
                    return ALWAYS_TRUE;
                }
                try {
                    realNode = JsonValidatorCache.this.resolver.resolve(key);
                }
                catch (JsonSchemaException e) {
                    return new FailingValidator(e.getValidationMessage());
                }
                ArrayList messages = Lists.newArrayList();
                JsonValidatorCache.this.syntaxValidator.validate(messages, realNode.getNode());
                if (!messages.isEmpty()) {
                    return new FailingValidator(messages);
                }
                Set<KeywordValidator> validators = JsonValidatorCache.this.keywordFactory.getValidators(realNode.getNode());
                return new InstanceValidator(realNode, validators);
            }
        };
    }

    private static final class FailingValidator
    implements JsonValidator {
        private final List<Message> messages;

        private FailingValidator(Message message) {
            this.messages = ImmutableList.of((Object)message);
        }

        private FailingValidator(List<Message> messages) {
            this.messages = ImmutableList.copyOf(messages);
        }

        @Override
        public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
            report.addMessages(this.messages);
        }
    }
}

