/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.messages.RefProcessingMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.processing.ref.SchemaLoader;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.JsonSchemaTree;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;

public final class RefResolverProcessor
implements Processor<ValidationData, ValidationData> {
    private final SchemaLoader loader;

    public RefResolverProcessor(SchemaLoader loader) {
        this.loader = loader;
    }

    @Override
    public ValidationData process(ProcessingReport report, ValidationData input) throws ProcessingException {
        JsonNode node;
        JsonRef ref;
        ProcessingMessage msg = input.newMessage();
        LinkedHashSet refs = Sets.newLinkedHashSet();
        JsonSchemaTree tree = input.getSchema().copy();
        while ((ref = RefResolverProcessor.nodeAsRef(node = tree.getCurrentNode())) != null) {
            JsonPointer ptr;
            if (!refs.add(ref = tree.resolve(ref))) {
                msg.msg(RefProcessingMessages.REF_LOOP).put("ref", ref).put("path", refs);
                throw new ProcessingException(msg);
            }
            if (!tree.containsRef(ref)) {
                tree = this.loader.get(ref.getLocator());
            }
            if ((ptr = tree.matchingPointer(ref)) == null) {
                msg.msg(RefProcessingMessages.DANGLING_REF).put("ref", ref);
                throw new ProcessingException(msg);
            }
            tree.setPointer(ptr);
        }
        return new ValidationData(tree, input.getInstance());
    }

    private static JsonRef nodeAsRef(JsonNode node) {
        JsonNode refNode = node.path("$ref");
        if (!refNode.isTextual()) {
            return null;
        }
        try {
            return JsonRef.fromString(refNode.textValue());
        }
        catch (JsonSchemaException ignored) {
            return null;
        }
    }
}

