/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;

public final class RequiredSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new RequiredSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private RequiredSyntaxChecker() {
        super("required", NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        Message.Builder msg = this.newMsg();
        int size = node.size();
        if (size == 0) {
            msg.setMessage("array must have at least one element");
            messages.add(msg.build());
            return;
        }
        HashSet set = Sets.newHashSet();
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            NodeType type = NodeType.getNodeType(element);
            if (type != NodeType.STRING) {
                msg.clearInfo().setMessage("incorrect type for array element").addInfo("index", index).addInfo("found", type).addInfo("expected", NodeType.STRING);
                messages.add(msg.build());
                continue;
            }
            if (set.add(element.textValue())) continue;
            msg.setMessage("elements in the array must be unique");
            messages.add(msg.clearInfo().build());
            return;
        }
    }
}

