/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.github.fge.jsonschema.library.MutableDictionary;
import com.github.fge.jsonschema.util.Frozen;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class Dictionary<T>
implements Frozen<MutableDictionary<T>> {
    final Map<String, T> entries;

    Dictionary(Map<String, T> map) {
        this.entries = ImmutableMap.copyOf(map);
    }

    Dictionary(MutableDictionary<T> builder) {
        this(builder.entries);
    }

    @VisibleForTesting
    public T get(String key) {
        return this.entries.get(key);
    }

    public Set<String> missingEntriesFrom(Set<String> set) {
        TreeSet ret = Sets.newTreeSet();
        ret.addAll(set);
        ret.removeAll(this.entries.keySet());
        return ret;
    }

    public Collection<T> valuesForKeys(Set<String> keys) {
        TreeMap map = Maps.newTreeMap();
        map.putAll(this.entries);
        map.keySet().retainAll(keys);
        return map.values();
    }

    @Override
    public MutableDictionary<T> thaw() {
        return new MutableDictionary(this);
    }
}

