/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public final class EmailFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute INSTANCE = new EmailFormatAttribute();

    private EmailFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        try {
            new InternetAddress(value.textValue(), true);
        }
        catch (AddressException ignored) {
            Message.Builder msg = EmailFormatAttribute.newMsg(fmt).setMessage("string is not a valid email address").addInfo("value", value);
            report.addMessage(msg.build());
        }
    }
}

