/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractDateFormatAttribute
extends FormatAttribute {
    private final String errmsg;
    private final DateTimeFormatter dtf;

    protected AbstractDateFormatAttribute(String fmt, String desc) {
        super(NodeType.STRING, new NodeType[0]);
        this.dtf = DateTimeFormat.forPattern((String)fmt);
        this.errmsg = "string is not a valid " + desc;
    }

    @Override
    public final void checkValue(String fmt, ValidationReport report, JsonNode value) {
        try {
            this.dtf.parseDateTime(value.textValue());
        }
        catch (IllegalArgumentException ignored) {
            Message.Builder msg = AbstractDateFormatAttribute.newMsg(fmt).setMessage(this.errmsg).addInfo("value", value);
            report.addMessage(msg.build());
        }
    }
}

