/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.data;

import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.tree.JsonTree;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.AsJson;

public final class FullData
implements MessageProvider {
    private final SchemaTree schema;
    private final JsonTree instance;

    public FullData(SchemaTree schema, JsonTree instance) {
        this.schema = schema;
        this.instance = instance;
    }

    public FullData(SchemaTree schema) {
        this(schema, null);
    }

    public SchemaTree getSchema() {
        return this.schema;
    }

    public JsonTree getInstance() {
        return this.instance;
    }

    public FullData withSchema(SchemaTree schema) {
        return new FullData(schema, this.instance);
    }

    public FullData withInstance(JsonTree instance) {
        return new FullData(this.schema, instance);
    }

    public ProcessingMessage newMessage() {
        ProcessingMessage ret = new ProcessingMessage();
        if (this.schema != null) {
            ret.put("schema", (AsJson)this.schema);
        }
        if (this.instance != null) {
            ret.put("instance", (AsJson)this.instance);
        }
        return ret;
    }
}

