/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ExceptionProvider;
import com.github.fge.jsonschema.exceptions.InvalidSchemaException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.AsJson;
import com.github.fge.jsonschema.util.NodeType;
import java.util.Collection;
import java.util.EnumSet;

public abstract class AbstractSyntaxChecker
implements SyntaxChecker {
    private static final ExceptionProvider EXCEPTION_PROVIDER = new ExceptionProvider(){

        public ProcessingException doException(ProcessingMessage message) {
            return new InvalidSchemaException(message);
        }
    };
    protected final String keyword;
    private final EnumSet<NodeType> types;

    protected AbstractSyntaxChecker(String keyword, NodeType first, NodeType ... other) {
        this.keyword = keyword;
        this.types = EnumSet.of(first, other);
    }

    @Override
    public final EnumSet<NodeType> getValidTypes() {
        return EnumSet.copyOf(this.types);
    }

    @Override
    public final void checkSyntax(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        NodeType type = NodeType.getNodeType((JsonNode)node);
        if (!this.types.contains(type)) {
            report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_TYPE).put("expected", this.types).put("found", (Object)type));
            return;
        }
        this.checkValue(pointers, report, tree);
    }

    protected abstract void checkValue(Collection<JsonPointer> var1, ProcessingReport var2, SchemaTree var3) throws ProcessingException;

    protected final <T> ProcessingMessage newMsg(SchemaTree tree, T msg) {
        return new ProcessingMessage().put("domain", "syntax").put("schema", (AsJson)tree).put("keyword", this.keyword).message(msg).setExceptionProvider(EXCEPTION_PROVIDER);
    }

    protected final JsonNode getNode(SchemaTree tree) {
        return tree.getNode().get(this.keyword);
    }
}

