/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.cfg.LoadingConfiguration;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.load.Dereferencing;
import com.github.fge.jsonschema.load.URIManager;
import com.github.fge.jsonschema.messages.RefProcessingMessages;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.concurrent.ExecutionException;

public final class SchemaLoader {
    private final URIManager manager;
    private final JsonRef namespace;
    private final LoadingCache<URI, JsonNode> cache;
    private final Dereferencing dereferencing;

    public SchemaLoader(LoadingConfiguration cfg) {
        this.namespace = JsonRef.fromURI((URI)cfg.getNamespace());
        this.dereferencing = cfg.getDereferencing();
        this.manager = new URIManager(cfg);
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<URI, JsonNode>(){

            public JsonNode load(URI key) throws ProcessingException {
                return SchemaLoader.this.manager.getContent(key);
            }
        });
        this.cache.putAll(cfg.getPreloadedSchemas());
    }

    public SchemaLoader() {
        this(LoadingConfiguration.byDefault());
    }

    public SchemaTree load(JsonNode schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"cannot register null schema");
        return this.dereferencing.newTree(schema);
    }

    public SchemaTree get(URI uri) throws ProcessingException {
        JsonRef ref = this.namespace.resolve(JsonRef.fromURI((URI)uri));
        ProcessingMessage msg = new ProcessingMessage().put("uri", (Object)ref);
        if (!ref.isAbsolute()) {
            throw new ProcessingException(msg.message((Object)RefProcessingMessages.URI_NOT_ABSOLUTE));
        }
        URI realURI = ref.toURI();
        try {
            JsonNode node = (JsonNode)this.cache.get((Object)realURI);
            return this.dereferencing.newTree(ref, node);
        }
        catch (ExecutionException e) {
            throw (ProcessingException)e.getCause();
        }
    }

    public String toString() {
        return this.cache.stats().toString();
    }
}

