/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.helpers.PositiveIntegerValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;

public final class MinLengthValidator
extends PositiveIntegerValidator {
    public MinLengthValidator(JsonNode digested) {
        super("minLength", digested);
    }

    @Override
    public void validate(Processor<FullData, ProcessingReport> processor, ProcessingReport report, FullData data) throws ProcessingException {
        int size = data.getInstance().getNode().textValue().length();
        if (size < this.intValue) {
            report.error(this.newMsg(data).message((Object)KeywordValidationMessages.STRING_TOO_SHORT).put(this.keyword, this.intValue).put("found", size));
        }
    }
}

