/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.processing.ProcessingCache;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullValidationContext;
import com.github.fge.jsonschema.processors.data.ValidationContext;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.processors.validation.ArraySchemaDigester;
import com.github.fge.jsonschema.processors.validation.ArraySchemaSelector;
import com.github.fge.jsonschema.processors.validation.ObjectSchemaDigester;
import com.github.fge.jsonschema.processors.validation.ObjectSchemaSelector;
import com.github.fge.jsonschema.processors.validation.ValidationContextEquivalence;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.JsonTree;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.google.common.base.Equivalence;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class ValidationProcessor
implements Processor<ValidationData, ProcessingReport> {
    private static final ThreadLocal<ProcessingReport> REPORT = new ThreadLocal();
    private final ProcessingCache<ValidationContext, FullValidationContext> cache;
    private final Processor<ValidationContext, FullValidationContext> processor;
    private final LoadingCache<JsonNode, ArraySchemaSelector> arrayCache;
    private final LoadingCache<JsonNode, ObjectSchemaSelector> objectCache;

    public ValidationProcessor(Processor<ValidationContext, FullValidationContext> processor) {
        this.processor = processor;
        this.arrayCache = CacheBuilder.newBuilder().build(ValidationProcessor.arrayLoader());
        this.objectCache = CacheBuilder.newBuilder().build(ValidationProcessor.objectLoader());
        this.cache = new ProcessingCache(ValidationContextEquivalence.getInstance(), this.loader());
    }

    public ProcessingReport process(ProcessingReport report, ValidationData input) throws ProcessingException {
        ValidationContext context = new ValidationContext(input);
        REPORT.set(report);
        FullValidationContext fullContext = (FullValidationContext)this.cache.get((Object)context);
        ValidationContext newContext = fullContext.getContext();
        ValidationData data = new ValidationData(newContext.getSchema(), input.getInstance());
        for (KeywordValidator validator : fullContext) {
            validator.validate(this, report, data);
        }
        if (!report.isSuccess()) {
            return report;
        }
        JsonNode node = data.getInstance().getNode();
        if (node.size() == 0) {
            return report;
        }
        if (node.isArray()) {
            this.processArray(report, data);
        } else {
            this.processObject(report, data);
        }
        return report;
    }

    private void processArray(ProcessingReport report, ValidationData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ArraySchemaDigester.getInstance().digest(schema);
        ArraySchemaSelector selector = (ArraySchemaSelector)this.arrayCache.getUnchecked((Object)digest);
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            JsonTree newInstance = instance.append(JsonPointer.empty().append(index));
            ValidationData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(index)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private void processObject(ProcessingReport report, ValidationData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ObjectSchemaDigester.getInstance().digest(schema);
        ObjectSchemaSelector selector = (ObjectSchemaSelector)this.objectCache.getUnchecked((Object)digest);
        ArrayList fields = Lists.newArrayList((Iterator)node.fieldNames());
        Collections.sort(fields);
        for (String field : fields) {
            JsonTree newInstance = instance.append(JsonPointer.of((Object)field, (Object[])new Object[0]));
            ValidationData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(field)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private static CacheLoader<JsonNode, ArraySchemaSelector> arrayLoader() {
        return new CacheLoader<JsonNode, ArraySchemaSelector>(){

            public ArraySchemaSelector load(JsonNode key) {
                return new ArraySchemaSelector(key);
            }
        };
    }

    private static CacheLoader<JsonNode, ObjectSchemaSelector> objectLoader() {
        return new CacheLoader<JsonNode, ObjectSchemaSelector>(){

            public ObjectSchemaSelector load(JsonNode key) {
                return new ObjectSchemaSelector(key);
            }
        };
    }

    private CacheLoader<Equivalence.Wrapper<ValidationContext>, FullValidationContext> loader() {
        return new CacheLoader<Equivalence.Wrapper<ValidationContext>, FullValidationContext>(){

            public FullValidationContext load(Equivalence.Wrapper<ValidationContext> key) throws ProcessingException {
                ValidationContext context = (ValidationContext)key.get();
                return (FullValidationContext)ValidationProcessor.this.processor.process((ProcessingReport)REPORT.get(), (MessageProvider)context);
            }
        };
    }

    public String toString() {
        return "validation processor";
    }
}

