/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.build;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullValidationContext;
import com.github.fge.jsonschema.processors.data.ValidationDigest;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.TreeMap;

public final class ValidatorBuilder
implements Processor<ValidationDigest, FullValidationContext> {
    private static final String ERRMSG = "failed to build keyword validator";
    private final Map<String, Constructor<? extends KeywordValidator>> constructors;

    public ValidatorBuilder(Dictionary<Constructor<? extends KeywordValidator>> dict) {
        this.constructors = ImmutableMap.copyOf(dict.asMap());
    }

    public FullValidationContext process(ProcessingReport report, ValidationDigest input) throws ProcessingException {
        TreeMap map = Maps.newTreeMap();
        for (Map.Entry<String, JsonNode> entry : input.getDigests().entrySet()) {
            String keyword = entry.getKey();
            JsonNode digest = entry.getValue();
            Constructor<? extends KeywordValidator> constructor = this.constructors.get(keyword);
            KeywordValidator validator = ValidatorBuilder.buildKeyword(constructor, digest);
            map.put(keyword, validator);
        }
        return new FullValidationContext(input.getContext(), map.values());
    }

    private static KeywordValidator buildKeyword(Constructor<? extends KeywordValidator> constructor, JsonNode node) throws ProcessingException {
        try {
            return constructor.newInstance(node);
        }
        catch (InstantiationException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
    }

    public String toString() {
        return "validator builder";
    }
}

