/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.util.Thawed;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public final class DictionaryBuilder<T>
implements Thawed<Dictionary<T>> {
    final Map<String, T> entries = Maps.newHashMap();

    DictionaryBuilder() {
    }

    DictionaryBuilder(Dictionary<T> dict) {
        this.entries.putAll(dict.entries);
    }

    public DictionaryBuilder<T> addEntry(String key, T value) {
        this.entries.put((String)Preconditions.checkNotNull((Object)key, (Object)"key must not be null"), Preconditions.checkNotNull(value, (Object)"value must not be null"));
        return this;
    }

    public DictionaryBuilder<T> addAll(Dictionary<T> other) {
        this.entries.putAll(other.entries);
        return this;
    }

    public DictionaryBuilder<T> removeEntry(String key) {
        this.entries.remove(key);
        return this;
    }

    @Override
    public Dictionary<T> freeze() {
        return new Dictionary(this);
    }
}

