/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.KeywordValidator;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.schema.SchemaContainer;
import com.github.fge.jsonschema.schema.SchemaNode;
import com.github.fge.jsonschema.validator.ArrayValidator;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.ObjectValidator;
import com.github.fge.jsonschema.validator.ValidationContext;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

final class InstanceValidator
implements JsonValidator {
    private final SchemaNode schemaNode;
    private final Set<KeywordValidator> validators;

    InstanceValidator(SchemaNode schemaNode, Set<KeywordValidator> validators) {
        this.validators = ImmutableSet.copyOf(validators);
        this.schemaNode = schemaNode;
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        SchemaContainer orig = context.getContainer();
        context.setContainer(this.schemaNode.getContainer());
        for (KeywordValidator validator : this.validators) {
            validator.validateInstance(context, report, instance);
            if (!report.hasFatalError()) continue;
            return;
        }
        if (instance.size() > 0 && report.isSuccess()) {
            JsonValidator validator = instance.isArray() ? new ArrayValidator(this.schemaNode.getNode()) : new ObjectValidator(this.schemaNode.getNode());
            validator.validate(context, report, instance);
        }
        context.setContainer(orig);
    }
}

