/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.hyperschema.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxValidator;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.net.MediaType;
import java.util.List;

public final class MediaTypeSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new MediaTypeSyntaxChecker();

    private MediaTypeSyntaxChecker() {
        super("mediaType", NodeType.STRING, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        String input = schema.get(this.keyword).textValue();
        try {
            MediaType.parse((String)input);
        }
        catch (IllegalArgumentException ignored) {
            messages.add(this.newMsg().setMessage("incorrect media type").addInfo("value", input).build());
        }
    }
}

