/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.PositiveIntegerKeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.ValidationContext;

public final class MinLengthKeywordValidator
extends PositiveIntegerKeywordValidator {
    public MinLengthKeywordValidator(JsonNode schema) {
        super("minLength", schema, NodeType.STRING);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        int len = instance.textValue().length();
        if (len >= this.intValue) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo(this.keyword, this.intValue).addInfo("found", len).setMessage("string is too short");
        report.addMessage(msg.build());
    }

    @Override
    public boolean alwaysTrue() {
        return this.intValue == 0;
    }
}

