/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxValidator;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.RhinoHelper;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class PatternPropertiesSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new PatternPropertiesSyntaxChecker();

    private PatternPropertiesSyntaxChecker() {
        super("patternProperties", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        HashSet regexes = Sets.newHashSet((Iterator)node.fieldNames());
        for (String regex : Ordering.natural().sortedCopy((Iterable)regexes)) {
            Message.Builder msg = this.newMsg().addInfo("key", regex);
            if (!RhinoHelper.regexIsValid(regex)) {
                msg.setMessage("key is not a valid ECMA 262 regex");
                messages.add(msg.build());
                continue;
            }
            JsonNode subSchema = node.get(regex);
            NodeType type = NodeType.getNodeType(subSchema);
            if (type != NodeType.OBJECT) {
                msg.setMessage("illegal key value").addInfo("found", type).addInfo("expected", NodeType.OBJECT);
                messages.add(msg.build());
                continue;
            }
            validator.validate(messages, subSchema);
        }
    }
}

