/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.draftv4.SchemaArrayKeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.ValidationContext;

public final class AnyOfKeywordValidator
extends SchemaArrayKeywordValidator {
    public AnyOfKeywordValidator(JsonNode schema) {
        super("anyOf", schema);
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        ValidationReport schemaReport = report.copy();
        for (JsonNode subSchema : this.subSchemas) {
            JsonValidator validator = context.newValidator(subSchema);
            ValidationReport subReport = report.copy();
            validator.validate(context, subReport, instance);
            if (subReport.isSuccess()) {
                return;
            }
            schemaReport.mergeWith(subReport);
        }
        report.mergeWith(schemaReport);
        Message.Builder msg = this.newMsg().setMessage("instance does not validate against any schema");
        report.addMessage(msg.build());
    }

    @Override
    public String toString() {
        return "any of " + this.subSchemas.size() + " schema(s)";
    }
}

