/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.examples.ExampleBase;
import com.github.fge.jsonschema.keyword.KeywordValidator;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.Keyword;
import com.github.fge.jsonschema.metaschema.BuiltinSchemas;
import com.github.fge.jsonschema.metaschema.MetaSchema;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxValidator;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.ValidationContext;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Example9
extends ExampleBase {
    public static void main(String ... args) throws IOException {
        JsonNode customSchema = Example9.loadResource("/custom-keyword.json");
        JsonNode good = Example9.loadResource("/custom-keyword-good.json");
        JsonNode bad = Example9.loadResource("/custom-keyword-bad.json");
        Keyword keyword = Keyword.withName("divisors").withSyntaxChecker(DivisorsSyntaxChecker.getInstance()).withValidatorClass(DivisorsKeywordValidator.class).build();
        MetaSchema metaSchema = MetaSchema.basedOn(BuiltinSchemas.DRAFTV4_CORE).addKeyword(keyword).build();
        JsonSchemaFactory factory = JsonSchemaFactory.builder().addMetaSchema(metaSchema, false).build();
        JsonSchema schema = factory.fromSchema(customSchema);
        ValidationReport report = schema.validate(good);
        Example9.printReport(report);
        report = schema.validate(bad);
        Example9.printReport(report);
    }

    public static final class DivisorsKeywordValidator
    extends KeywordValidator {
        private final Set<BigInteger> divisors;

        public DivisorsKeywordValidator(JsonNode schema) {
            super("divisors", NodeType.INTEGER);
            ImmutableSet.Builder set = ImmutableSet.builder();
            for (JsonNode element : schema.get(this.keyword)) {
                set.add((Object)element.bigIntegerValue());
            }
            this.divisors = set.build();
        }

        @Override
        public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
            BigInteger value = instance.bigIntegerValue();
            HashSet failed = Sets.newHashSet();
            for (BigInteger divisor : this.divisors) {
                if (value.mod(divisor).equals(BigInteger.ZERO)) continue;
                failed.add(divisor);
            }
            if (failed.isEmpty()) {
                return;
            }
            Message msg = this.newMsg().setMessage("integer value is not a multiple of all divisors").addInfo("divisors", Ordering.natural().sortedCopy(this.divisors)).addInfo("failed", Ordering.natural().sortedCopy((Iterable)failed)).build();
            report.addMessage(msg);
        }

        @Override
        public String toString() {
            return "divisors: " + Ordering.natural().sortedCopy(this.divisors);
        }
    }

    private static final class DivisorsSyntaxChecker
    extends AbstractSyntaxChecker {
        private static final SyntaxChecker INSTANCE = new DivisorsSyntaxChecker();

        public static SyntaxChecker getInstance() {
            return INSTANCE;
        }

        private DivisorsSyntaxChecker() {
            super("divisors", NodeType.ARRAY, new NodeType[0]);
        }

        @Override
        public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
            JsonNode node = schema.get(this.keyword);
            Message.Builder msg = this.newMsg();
            int size = node.size();
            if (size == 0) {
                msg.setMessage("array must have at least one element");
                messages.add(msg.build());
                return;
            }
            HashSet set = Sets.newHashSet();
            for (int index = 0; index < size; ++index) {
                JsonNode element = node.get(index);
                NodeType type = NodeType.getNodeType(element);
                if (!set.add(element)) {
                    msg.clearInfo().setMessage("duplicate elements in array");
                    messages.add(msg.build());
                    return;
                }
                if (type == NodeType.INTEGER) continue;
                msg.setMessage("array element has incorrect type").addInfo("expected", NodeType.INTEGER).addInfo("index", index);
                messages.add(msg.build());
            }
        }
    }
}

