/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedHashSet;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.report.Domain;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.jsonschema.schema.SchemaNode;
import org.eel.kitchen.jsonschema.schema.SchemaRegistry;

final class JsonResolver {
    private final SchemaRegistry registry;

    JsonResolver(SchemaRegistry registry) {
        this.registry = registry;
    }

    SchemaNode resolve(SchemaNode schemaNode) throws JsonSchemaException {
        JsonNode refNode;
        Message.Builder msg = Domain.REF_RESOLVING.newMessage().setKeyword("$ref").setFatal(true);
        SchemaContainer container = schemaNode.getContainer();
        JsonNode node = schemaNode.getNode();
        LinkedHashSet<JsonRef> refs = new LinkedHashSet<JsonRef>();
        while ((refNode = node.path("$ref")).isTextual()) {
            JsonRef ref;
            try {
                ref = JsonRef.fromString(refNode.textValue());
            }
            catch (JsonSchemaException ignored) {
                break;
            }
            JsonRef source = container.getLocator();
            JsonRef target = source.resolve(ref);
            if (!refs.add(target)) {
                msg.setMessage("ref loop detected").addInfo("path", refs);
                throw new JsonSchemaException(msg.build());
            }
            if (!container.contains(target)) {
                container = this.registry.get(target.getLocator());
            }
            if (!(node = container.resolve(target)).isMissingNode()) continue;
            msg.setMessage("dangling JSON Reference").addInfo("ref", target);
            throw new JsonSchemaException(msg.build());
        }
        return new SchemaNode(container, node);
    }
}

