/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.draftv4.SchemaArrayKeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class AnyOfKeywordValidator
extends SchemaArrayKeywordValidator {
    public AnyOfKeywordValidator(JsonNode schema) {
        super("anyOf", schema);
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        ValidationReport schemaReport = report.copy();
        for (JsonNode subSchema : this.subSchemas) {
            JsonValidator validator = context.newValidator(subSchema);
            ValidationReport subReport = report.copy();
            validator.validate(context, subReport, instance);
            if (subReport.isSuccess()) {
                return;
            }
            schemaReport.mergeWith(subReport);
        }
        report.mergeWith(schemaReport);
        Message.Builder msg = this.newMsg().setMessage("instance does not validate against any schema");
        report.addMessage(msg.build());
    }

    @Override
    public String toString() {
        return "any of " + this.subSchemas.size() + " schema(s)";
    }
}

