/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.draftv4.SchemaArrayKeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class AllOfKeywordValidator
extends SchemaArrayKeywordValidator {
    public AllOfKeywordValidator(JsonNode schema) {
        super("allOf", schema);
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        ValidationReport subReport = report.copy();
        for (JsonNode subSchema : this.subSchemas) {
            JsonValidator validator = context.newValidator(subSchema);
            validator.validate(context, subReport, instance);
            if (subReport.isSuccess()) continue;
            report.mergeWith(subReport);
            Message.Builder msg = this.newMsg().setMessage("instance does not validate against all schemas");
            report.addMessage(msg.build());
        }
    }

    @Override
    public String toString() {
        return "all of " + this.subSchemas.size() + " schema(s)";
    }
}

