/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class PhoneNumberFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute INSTANCE = new PhoneNumberFormatAttribute();
    private static final PhoneNumberUtil parser = PhoneNumberUtil.getInstance();

    private PhoneNumberFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        String input = value.textValue();
        try {
            if (input.startsWith("+")) {
                parser.parse(input, "ZZ");
            } else {
                parser.parse(input, "FR");
            }
        }
        catch (NumberParseException ignored) {
            Message.Builder msg = PhoneNumberFormatAttribute.newMsg(fmt).addInfo("value", value).setMessage("string is not a recognized phone number");
            report.addMessage(msg.build());
        }
    }
}

