/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.InetAddresses;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class IPV6FormatAttribute
extends FormatAttribute {
    private static final FormatAttribute INSTANCE = new IPV6FormatAttribute();
    private static final int IPV6_LENGTH = 16;

    private IPV6FormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        String ipaddr = value.textValue();
        if (InetAddresses.isInetAddress((String)ipaddr) && InetAddresses.forString((String)ipaddr).getAddress().length == 16) {
            return;
        }
        Message.Builder msg = IPV6FormatAttribute.newMsg(fmt).setMessage("string is not a valid IPv6 address").addInfo("value", value);
        report.addMessage(msg.build());
    }
}

