/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.eel.kitchen.jsonschema.util.jackson.CustomJsonNodeFactory;

public final class JsonLoader {
    private static final ObjectMapper MAPPER = CustomJsonNodeFactory.getMapper();
    private static final Class<JsonLoader> myself = JsonLoader.class;

    private JsonLoader() {
    }

    public static JsonNode fromResource(String resource) throws IOException {
        JsonNode ret;
        InputStream in = myself.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("resource " + resource + " not found");
        }
        try {
            ret = MAPPER.readTree(in);
        }
        finally {
            in.close();
        }
        return ret;
    }

    public static JsonNode fromURL(URL url) throws IOException {
        return MAPPER.readTree(url);
    }

    public static JsonNode fromPath(String path) throws IOException {
        JsonNode ret;
        FileInputStream in = new FileInputStream(path);
        try {
            ret = MAPPER.readTree((InputStream)in);
        }
        finally {
            in.close();
        }
        return ret;
    }

    public static JsonNode fromFile(File file) throws IOException {
        JsonNode ret;
        FileInputStream in = new FileInputStream(file);
        try {
            ret = MAPPER.readTree((InputStream)in);
        }
        finally {
            in.close();
        }
        return ret;
    }

    public static JsonNode fromReader(Reader reader) throws IOException {
        return MAPPER.readTree(reader);
    }

    public static JsonNode fromString(String json) throws IOException {
        return JsonLoader.fromReader(new StringReader(json));
    }
}

