/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.report.Domain;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.schema.AddressingMode;
import org.eel.kitchen.jsonschema.schema.SchemaBundle;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.jsonschema.uri.URIManager;

public final class SchemaRegistry {
    private final JsonRef namespace;
    private final LoadingCache<URI, SchemaContainer> cache;
    private final AddressingMode addressingMode;

    public SchemaRegistry(final URIManager manager, URI namespace, final AddressingMode addressingMode) {
        this.addressingMode = addressingMode;
        this.namespace = JsonRef.fromURI(namespace);
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<URI, SchemaContainer>(){

            public SchemaContainer load(URI key) throws JsonSchemaException {
                return addressingMode.forSchema(key, manager.getContent(key));
            }
        });
    }

    public SchemaContainer register(JsonNode schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"cannot register null schema");
        SchemaContainer container = this.addressingMode.forSchema(schema);
        JsonRef ref = container.getLocator();
        if (ref.isAbsolute()) {
            this.cache.put((Object)ref.getLocator(), (Object)container);
        }
        return container;
    }

    public SchemaContainer get(URI uri) throws JsonSchemaException {
        JsonRef ref = this.namespace.resolve(JsonRef.fromURI(uri));
        Message.Builder msg = Domain.REF_RESOLVING.newMessage().setFatal(true).setKeyword("N/A").addInfo("uri", ref);
        if (!ref.isAbsolute()) {
            throw new JsonSchemaException(msg.setMessage("URI is not absolute").build());
        }
        URI realURI = ref.toURI();
        try {
            return (SchemaContainer)this.cache.get((Object)realURI);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            msg.addInfo("exception-class", cause.getClass().getName()).addInfo("exception-message", cause.getMessage()).setMessage("failed to load schema from URI");
            throw new JsonSchemaException(msg.build());
        }
    }

    public void addBundle(SchemaBundle bundle) {
        Map<URI, JsonNode> map = bundle.getSchemas();
        for (Map.Entry<URI, JsonNode> entry : map.entrySet()) {
            URI uri = entry.getKey();
            JsonNode schema = entry.getValue();
            SchemaContainer container = this.addressingMode.forSchema(uri, schema);
            this.cache.put((Object)uri, (Object)container);
        }
    }
}

