/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.metaschema;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.util.JsonLoader;

public enum BuiltinSchema {
    DEFAULT_CORE("http://json-schema.org/schema#", "/draftv3/schema", "default core schema"),
    DRAFTV3_CORE("http://json-schema.org/draft-03/schema#", "/draftv3/schema", "draft v3 core schema"),
    DRAFTV4_CORE("http://json-schema.org/draft-04/schema#", "/draftv4/schema", "draft v4 core schema"),
    DRAFTV3_LINKS("http://json-schema.org/draft-03/links#", "/draftv3/links", "draft v3 link description object (LDO) schema"),
    DRAFTV3_HYPERSCHEMA("http://json-schema.org/draft-03/hyper-schema#", "/draftv3/hyper-schema", "draft v3 hyper schema"),
    DEFAULT_HYPERSCHEMA("http://json-schema.org/hyper-schema#", "/draftv3/hyper-schema", "default hyper schema");

    private final JsonRef locator;
    private final JsonNode rawSchema;
    private final String desc;

    private BuiltinSchema(String uri, String resource, String desc) {
        try {
            this.locator = JsonRef.fromString(uri);
            this.rawSchema = JsonLoader.fromResource(resource);
        }
        catch (JsonSchemaException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        this.desc = desc;
    }

    public URI getURI() {
        return this.locator.toURI();
    }

    public JsonNode getRawSchema() {
        return this.rawSchema;
    }

    public String toString() {
        return this.desc + " (" + this.locator + ')';
    }
}

