/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class DraftV3PropertiesKeywordValidator
extends KeywordValidator {
    private final Set<String> required;

    public DraftV3PropertiesKeywordValidator(JsonNode schema) {
        super("properties", NodeType.OBJECT);
        Map<String, JsonNode> map = ((ObjectNode)schema.get(this.keyword)).asMap();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            if (!entry.getValue().path("required").asBoolean(false)) continue;
            builder.add((Object)entry.getKey());
        }
        this.required = builder.build();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        HashSet fields = Sets.newHashSet((Iterator)instance.fieldNames());
        Sets.SetView missing = Sets.difference(this.required, (Set)fields);
        if (missing.isEmpty()) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo("required", Ordering.natural().sortedCopy(this.required)).addInfo("missing", Ordering.natural().sortedCopy((Iterable)missing)).setMessage("required property(ies) not found");
        report.addMessage(msg.build());
    }

    @Override
    public boolean alwaysTrue() {
        return this.required.isEmpty();
    }

    @Override
    public String toString() {
        return this.keyword + ": " + (this.required.isEmpty() ? "none" : Integer.valueOf(this.required.size())) + " required";
    }
}

